/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.Utils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SelectionTreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class LauncherUtils
implements HMCSessionListener,
UILog {
    public static final int ID_LAUNCH_TYPE_UNKNOWN = 0;
    public static final int ID_LAUNCH_TYPE_CONSOLE_TASK = 1;
    public static final int ID_LAUNCH_TYPE_TARGETED_TASK = 2;
    public static final int ID_LAUNCH_TYPE_DEFAULT_TASK = 3;
    public static final int ID_LAUNCH_TYPE_BRING_TO_FOREGROUND = 4;
    private static HashMap sessionInstances = new HashMap();
    private static Object lock = new Object();
    private static int numSessions = 0;
    private MyClient client;
    private HMCSession session;
    private static final String TRACE_MASKT = "HUILU  T";
    private static final String TRACE_MASKF = "HUILU  F";
    private static final String TRACE_MASKD = "HUILU  D";

    private LauncherUtils() {
        Trace.trace(TRACE_MASKT, "-> LauncherUtils.LauncherUtils()");
        try {
            if (this.client == null) {
                Trace.trace(TRACE_MASKT, "   construct a new Client");
                this.client = new MyClient();
                this.client.init();
            }
        }
        catch (TaskletException exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(UILog.logInfo, 1794, exc).log();
        }
        Trace.trace(TRACE_MASKT, "<- LauncherUtils.LauncherUtils()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LauncherUtils getLauncherUtils(HMCSession session) {
        LauncherUtils instance = null;
        boolean instanceAdded = false;
        Object object = lock;
        synchronized (object) {
            instance = (LauncherUtils)sessionInstances.get(session);
            if (instance == null) {
                ++numSessions;
                instance = new LauncherUtils();
                instance.session = session;
                sessionInstances.put(session, instance);
                instanceAdded = true;
            }
        }
        if (instanceAdded) {
            session.addHMCSessionListener(instance);
        }
        return instance;
    }

    public boolean launchTask(String taskShortId, String targetShortIds, String parentShortId, int launchType) throws HException {
        if (launchType != 3 && taskShortId == null) {
            throw new IllegalArgumentException("taskShortId is null");
        }
        boolean result = false;
        if (launchType == 1 && Utils.checkForActiveTask(taskShortId, this.session)) {
            launchType = 4;
        }
        if (launchType == 4) {
            this.bringTaskToForeground(taskShortId);
        } else {
            Map map;
            HashSet<String> targets = null;
            if (targetShortIds != null) {
                targets = new HashSet<String>();
                StringTokenizer tokens = new StringTokenizer(targetShortIds);
                while (tokens.hasMoreTokens()) {
                    targets.add(tokens.nextToken());
                }
            }
            if ((map = this.client.getLaunchData(taskShortId, targets, parentShortId, launchType)) != null) {
                UIInfo taskUIInfo = (UIInfo)map.get("TaskUIInfo");
                String mergedKey = (String)map.get("MergedKey");
                if (mergedKey == null) {
                    this.launchTask(map, taskUIInfo, taskShortId);
                } else {
                    Set launchSet = (Set)map.get("LaunchSet");
                    Iterator iterator = launchSet.iterator();
                    while (iterator.hasNext()) {
                        this.launchTask((Map)iterator.next(), taskUIInfo, taskShortId);
                    }
                }
                result = true;
            }
        }
        return result;
    }

    public boolean bringTaskToForeground(String taskShortId) {
        Trace.trace(TRACE_MASKT, "-> LauncherUtils.bringTaskToForeground(), task shortId is " + taskShortId);
        boolean result = false;
        Collection taskPortals = this.session.getRunningTasks();
        Trace.trace(TRACE_MASKT, "   number of running tasks is " + taskPortals.size());
        Iterator iterator = taskPortals.iterator();
        while (!result && iterator.hasNext()) {
            PanelModelTaskPortal nextTaskPortal = (PanelModelTaskPortal)iterator.next();
            PresentationTask presTask = nextTaskPortal.getPresentationTask();
            if (presTask != null) {
                PresentationTaskParms parms = presTask.getParms();
                if (parms != null) {
                    String shortId = parms.getUIShortId();
                    if (shortId == null || !shortId.equals(taskShortId)) continue;
                    nextTaskPortal.requestFocus();
                    result = true;
                    continue;
                }
                Trace.trace(TRACE_MASKT, "   there is no PresentationTaskParms for PanelModelTaskPortal " + nextTaskPortal);
                continue;
            }
            Trace.trace(TRACE_MASKT, "   there is no PresentationTask for PanelModelTaskPortal " + nextTaskPortal);
        }
        Trace.trace(TRACE_MASKF, "   result is " + result);
        Trace.trace(TRACE_MASKT, "<- LauncherUtils.bringTaskToForegroud()");
        return result;
    }

    private void launchTask(Map map, UIInfo taskUIInfo, String taskShortId) throws HException {
        String taskClassName = (String)map.get("TaskClassName");
        SelectionTreeNode root = (SelectionTreeNode)map.get("TargetTree");
        ObjectId taskObjectId = (ObjectId)map.get("TaskObjectId");
        PresentationTaskParms parms = new PresentationTaskParms(root, taskObjectId);
        parms.setUIInfo(taskUIInfo);
        parms.setUIShortId(taskShortId);
        Trace.trace(TRACE_MASKF, "========== launch info ==========");
        Trace.trace(TRACE_MASKF, "task class name: " + taskClassName);
        Trace.trace(TRACE_MASKF, "task ObjectId: " + taskObjectId);
        Trace.trace(TRACE_MASKF, "task shortId: " + taskShortId);
        Trace.trace(TRACE_MASKF, "dump of target tree follows...");
        root.dump();
        Trace.trace(TRACE_MASKF, "========== end launch info ==========");
        TaskLauncher.startTask(parms, taskClassName, this.session, false);
    }

    public void sessionDisconnected(HMCSession session) {
    }

    public void sessionConnected(HMCSession session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HMCSession session) {
        Trace.trace(TRACE_MASKF, "-> UILauncherUtils.sessionDestroyed()");
        Object object = lock;
        synchronized (object) {
            sessionInstances.remove(session);
            if (--numSessions == 0) {
                this.client.terminate();
            }
        }
        Trace.trace(TRACE_MASKF, "<- UILauncherUtils.sessionDestroyed()");
    }

    public void clientConnectivityLost(HMCSession session) {
    }

    public void clientConnectivityGained(HMCSession session) {
    }

    public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
    }

    public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
    }

    public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
    }

    class MyClient
    extends Client {
        MyClient() throws TaskletException {
            super("com.ibm.hwmca.fw.ui.UIQueryTasklet", null);
        }

        public synchronized TaskletResponse request(TaskletRequest request) throws TaskletException {
            return super.request(request);
        }

        ObjectId getObjectId(String shortId) throws TaskletException {
            Trace.trace(LauncherUtils.TRACE_MASKF, "-> UILauncherUtils.MyClient.getObjectId()");
            TaskletRequest request = new TaskletRequest();
            request.setData("request", "GetObjectId");
            TaskletResponse response = this.request(request);
            ObjectId result = (ObjectId)response.getData("ObjectId");
            Trace.trace(LauncherUtils.TRACE_MASKF, "<- UILauncherUtils.MyClient.getObjectId()");
            return result;
        }

        Map getLaunchData(String taskShortId, Set targets, String parentShortId, int launchType) throws TaskletException {
            Trace.trace(LauncherUtils.TRACE_MASKF, "-> UILauncherUtils.MyClient.getLaunchInformation()");
            TaskletRequest request = new TaskletRequest();
            request.setData("request", "GetLaunchData");
            request.setData("LaunchType", new Integer(launchType));
            if (taskShortId != null) {
                request.setData("TaskShortId", taskShortId);
            }
            if (launchType != 1 && parentShortId != null) {
                request.setData("ParentShortId", parentShortId);
            }
            if (targets != null) {
                request.setData("TargetShortIds", targets);
            }
            TaskletResponse response = this.request(request);
            Map info = response.getDataMap();
            Trace.trace(LauncherUtils.TRACE_MASKF, "<- UILauncherUtils.MyClient.getLaunchInformation()");
            return info;
        }
    }
}

